/*
 * MP3 quantization
 *
 * Copyright (c) 1999 Mark Taylor
 * Copyright (c) 2001,2002,2003 gogo-developer
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef LAME_QUANTIZE_H
#define LAME_QUANTIZE_H

#include "util.h"

void CBR_iteration_loop(gogo_thread_data *tl, FLOAT8 pe[2][2], FLOAT8 ms_ratio[2], int *mean_bits);
void ABR_iteration_loop(gogo_thread_data *tl, FLOAT8 pe[2][2], FLOAT8 ms_ratio[2], int *mean_bits);
void VBR_iteration_loop(gogo_thread_data *tl, FLOAT8 pe[2][2], FLOAT8 ms_ratio[2], int *mean_bits);

void iteration_finish (int l3_enc  [2][2][576], III_side_info_t *l3_side,
             III_scalefac_t  scalefac[2][2], const int mean_bits );
#endif /* LAME_QUANTIZE_H */
