/*
 *   part of this code is origined from
 *   GOGO-no-coda
 *
 *   Copyright(C) 2001,2002,2003 gogo-developer
 */

#ifndef THREAD_H_
#define THREAD_H_

/* ץåȥۡ¸ */

typedef void* (*gogo_thread_func)(void *); 

/*
 *	ޥåɤбϡ
 *	Υץåȥۡ˹碌ưʲηȴؿޤϥޥѰդ뤳
 *
 *	ץåȥۡ¸η 
 *
 *	gogo_thread	åɾǼ뷿
 *	gogo_mutex	ߥ塼ƥåǼ뷿
 *  gogo_semaphore ޥեǼ뷿
 *
 *	ץåȥۡ¸δؿޤϥޥ 
 *	int ֤ؿｪλ 0 ֤۾ｪλ 0 ֤ȡ
 *
 *	åɴطν¾ΥåɴطؿȤ˰٤ƤФ롣
 *	int gogo_initialize_thread_unit(void)
 *
 *	åɴطνλ٤ƤФ롣Ƥ塢¾ΥåɴؿƤǤϤʤ
 *	int gogo_finalize_thread_unit(void)
 *
 *	åɤ롣
 *	int gogo_create_thread(gogo_thread* pthread, gogo_thread_func func, void *data)
 *
 *	åɤνλԤġ
 *	int gogo_join_thread(gogo_thread* pthread)
 *
 *	åɤ˴롣˴˽λԤĤȡ
 *	int gogo_destroy_thread(gogo_thread* pthread)
 *
 *	ߥ塼ƥå롣
 *	Ƶߥ塼ƥåɤϥץåȥۡ¸ʤΤǡƵɤ˰¸ʤ褦˻Ȥȡ
 *	int gogo_create_mutex(gogo_mutex* pmutex)
 *
 *	ߥ塼ƥå˴롣
 *	int gogo_destroy_mutex(gogo_mutex* pmutex)
 *
 *	ߥ塼ƥå롣ǤޤǱʱԤġ
 *	int gogo_lock_mutex(gogo_mutex* pmutex)
 *
 *	ߥ塼ƥå롣
 *	int gogo_unlock_mutex(gogo_mutex* pmutex)
 *
 *	ޥե롣
 *	02ͥޥե
 *  int gogo_create_semaphore(gogo_semaphore* pSemaphore)
 *
 *	ޥե˴롣
 *  int gogo_destroy_semaphore(gogo_semaphore* pSemaphore)
 *
 *	ޥե롣ǤޤǱʱԤġ
 *  int gogo_lock_semaphore(gogo_semaphore* pSemaphore)
 *
 *	ޥե롣
 *  int gogo_unlock_semaphore(gogo_semaphore* pSemaphore)
 *
 *	ޥե롣Ǥޤ timeout ߥԤġ
 *  Ǥ 0 ֤顼ޤ timeout 顢0֤
 *  int gogo_trylocktimeout_semaphore(gogo_semaphore* pSemaphore, int timeout)
 *
 *	¾Υåɤ˼¹ԸͿ롣
 *  void gogo_yield_thread()						
 *
 *	CPU ο *pCPUs ˡ륹åɿ *pTHREADs ֤
 *	狼ʤξɬ1ˤ뤳ȡ
 *	int gogo_get_cpu_count(int *pCPUs, int *pTHREADs)
 *
 *	åɥǡ¤Τ֤ѿС
 *	 GOGO_THREAD_VARIABLES Ƥ
 *
 */

#define	MT_ENCODER

#if		defined(USE_WINTHREAD)
#  include	"../win/thread_win.h"
#elif	defined(USE_PTHREAD)
#  include	"../pthread/thread_pthread.h"
#elif defined(USE_BTHREAD)
#  include	"../be/thread_be.h"
#elif defined(USE_OS2THREAD)
#  include	"../os2/thread_os2.h"
#elif defined(USE_RFORK)
#  include	"../rfork/thread_rfork.h"
#else
#  undef	MT_ENCODER
#  define	ST_ENCODER
#  define	gogo_get_cpu_count(pCPU,pTHREADs) ((*(pCPU)=1),(*(pTHREADs)=1),0)
#endif

typedef unsigned int uint32;

/**
 * ץåȥۡ¸ѿ
 */
typedef struct gogo_thread_data_s {
/* ץåȥۡ¸ѿ */
	float	mfbuf[2][4][576];	/* ->FFT, ->PFB */

  /* variables for newmdct.c */
        float	(*sb[4])[18][SBLIMIT];
        float	sb_sample[3][2][18][SBLIMIT];  /* PFB -> MDCT */

        float	xr[2][2][576];         /* MDCT -> Non-Linear Quantization  */
	uint32	xr_sign[2][2][576];

        float	xrpow[2][2][576];      /* Non-Linear Quantization -> Iteration Loop */
	float	work_xrpow[576]; //, save_xrpow[576], best_xrpow[576];	/* quantize.c */
        float	xrpow_sum[2][2];
        float	xrpow_max[2][2];

	int	l3_enc[2][2][576];
	III_scalefac_t	scalefac[2][2];

	int	ath_over[2][2];		/* calc_xmin() -> calc_noise() */
	III_psy_xmin	l3_xmin[2][2];	/* calc_xmin() -> calc_noise() */

	/* fft and energy calculation    */
        float	wsamp_L[2 /*granule*/][2 /*channel*/][BLKSIZE];     /* fft() -> L3psycho_anal() */
        float	wsamp_S[2 /*granule*/][2 /*channel*/][3][BLKSIZE_s];/* fft() -> L3psycho_anal() */
/* BLKSIZE=1024, BLKSIZE_s = 256 => max(BLKSIZE,BLKSIZE_s*3) = 1024 */
//		float	psywork[BLKSIZE*4];		/* wsampl_{L,S} 4ʬ(energyȶѤۤ褤?) */
		float	psywork[576*2*4*4];		/* FFTǤwork(576*2*4*4*4byte)ȤƻȤ */
		                                /* ̿Ťʤʤ quantize.c  distort ǤⶦѤƻȤ */
        float	energy[HBLKSIZE*4];              /* ΰ4ܤˤFFTˤޤȤƽǽ */
        float	energy_s[3][HBLKSIZE_s*4];       /* ΰ4ܤˤFFTˤޤȤƽǽ */

	/* psycho acoustics */
	float	tot_ener[4];	/* private copy of RW.tot_ener */
	III_side_info_t	l3_side;

/* ץåȥۡ¸åɥѿ */
#ifdef GOGO_THREAD_VARIABLES
	GOGO_THREAD_VARIABLES;
#endif

/* 饤ȴطʤΤϤ鲼 */
	struct gogo_thread_data_s	*next;
	void	*unaligned;
	int	tid;

	int	padding;		  /* padding for the current frame? */
	int	mode_ext;

	int	bitrate_index;
	int	ResvSize;

	// WMP6.4бΤ ancillary ä part2_3_length ɲäƤΤ
	// ɲäӥåȿ
	int additional_part2_3_length[2 /*granule*/][2 /*channel*/]; 

#ifdef	MT_ENCODER
	int	exit_status;
	gogo_thread	thread;
	gogo_mutex	*critical_region;
#endif
} gogo_thread_data;	// <- gogo2encodeframe_arg_t

#endif // THREAD_H_

